/* (c) Terasense Group, Inc., 2016

The simplest programm that read data from a TeraFAST device.

*/


#include "libterafast.h"

#include <stdlib.h>

int main(int argc, char* argv[])
{
	TF_RES res = TF_OK;
	TF_DATA buf;

	// Initialize the device

	res = tfInit();
	if (res != TF_OK) {
		printf("Device initialization failed, code %d", res);
		return res;
	}
	else
		printf("Device initialized.\nReading %d pixels as %d lines by %d pixels.\n", dataLength, frameLength, frameSize);

	//  Change length of the frame.
	tfSetFrameLength(10000);

	//	Turn on the difference mode if needed.
	//	tfSetDifference(1);

	// Allocate memory for the data buffer. Notice that dataLength variable is not set prior initialization.
	buf = (TF_DATA)malloc(dataLength * sizeof(TF_ELEMENT));


	// Turn on external sync;
	tfSetExternalSync(1);

	// If you want to set parameters of the synchronization - active edge, sync divider, holdoff - you should do it before the start of the acquistion.
	//	tfSetEdge(0);
	//	tfSetSyncHoldoff(3);
	//	tfSetSyncDivider(2);
	

	// Start data aquisition
	res = tfStart();

	int timeout = 1000; //1000 ms


// Read data with timeout; timeout should be longer than frameLength/(rate of sync pulses).

	res = tfRead_T(buf, timeout);
	if (res == TF_TIMEOUT) {
		printf("Timeout reading data, is the sync signal applied?\n");
	}
	else if (res != TF_OK) {
		printf("Error reading data, code %d\n", res);
	}
	else{
// Do something with the data.
		for (int y = 0; y < frameLength; y++){
			for (int x = 0; x < frameSize; x++){
				if(buf[x + y * frameSize]>100) {
				printf("aaa%4d %4d %4d\n", x, y, buf[x + y*frameSize]);
				}
			}
			//printf("\n");
		}
	}
// Stop data aquisition.
	res = tfStop();

// Close the device.
	res = tfClose();

//Release memory
	free(buf);


	printf("Press ENTER to continue.");
	getchar();

	

	return res;

}

